// multsrDlg.cpp : implementation file
//

/*
  This example demonstrates the use of two SR structures from the same
  application.  Separate structures are used when making use of more than
  one subsystem on the same board or making use of more than one board.

  When more than one board is used, and they are associated with two different
  drivers, the SelectDriverLINX(instanceHandle)funciton must be used.

*/

#include "stdafx.h"
#include "multsr.h"
#include "multsrDlg.h"

#ifdef _DEBUG 
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultsrDlg dialog

CMultsrDlg::CMultsrDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultsrDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMultsrDlg)
	m_divalue = _T("");
	m_aivalue = _T("");
	m_deviceNum = 0;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMultsrDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultsrDlg)
	DDX_Control(pDX, IDC_BUTTON3, m_aiButton);
	DDX_Control(pDX, IDC_BUTTON2, m_diButton);
	DDX_Text(pDX, IDC_DIVALUE, m_divalue);
	DDX_Text(pDX, IDC_AIVALUE, m_aivalue);
	DDX_Text(pDX, IDC_DEVICENUM, m_deviceNum);
	DDV_MinMaxUInt(pDX, m_deviceNum, 0, 5);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMultsrDlg, CDialog)
	//{{AFX_MSG_MAP(CMultsrDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	ON_BN_CLICKED(IDC_INIT, OnInit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultsrDlg message handlers

BOOL CMultsrDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_SR1=NULL;
	m_SR2=NULL;
	m_driverInstance1=NULL;
	m_driverInstance2=NULL;

	return TRUE;  // return TRUE unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMultsrDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMultsrDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMultsrDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
}

void CMultsrDlg::OnButton1() 
{
	// TODO: Add your control notification handler code here
	//close down DriverLINX
	if (m_driverInstance1 != NULL)
	{
      SelectDriverLINX(m_driverInstance1);
      CloseDriverLINX(m_driverInstance1);
      m_driverInstance1 = NULL;
	}


	if (m_SR1 != NULL)
	{
       delete m_SR1;
	   m_SR1=NULL;
	}
	
// do same for second Service Request
	if (m_driverInstance2 != NULL)
	{
      SelectDriverLINX(m_driverInstance2);
      CloseDriverLINX(m_driverInstance2);
      m_driverInstance2 = NULL;
	}


	if (m_SR2 != NULL)
	{
       delete m_SR2;
	   m_SR2=NULL;
	}
	
	OnOK();
	
}

void CMultsrDlg::OnButton2() 
{
	// switch to driver for m_SR1
	SelectDriverLINX(m_driverInstance1);
	m_SR1->operation=START;
	m_SR1->subsystem=DI;
	m_SR1->mode=POLLED;
	m_SR1->channels.nChannels=1;
	m_SR1->channels.chanGain[0].channel=0;
		m_SR2->status.typeStatus=IOVALUE;
	if (DriverLINX(m_SR1) == NoErr)
	{  // success
		m_divalue.Format("%d",m_SR1->status.u.ioValue);
		// = m_SR1->status.u.ioValue;
		UpdateData(FALSE); // update the Dialog
	}
    else  // problem has occured
	{ showMessage(m_SR1);}  // display the error message box
}

void CMultsrDlg::OnButton3() 
{
	// TODO: Add your control notification handler code here
	SelectDriverLINX(m_driverInstance2);
	m_SR2->operation=START;
	m_SR2->subsystem=AI;
	m_SR2->mode=POLLED;
	m_SR2->channels.nChannels=1;
	m_SR2->channels.chanGain[0].channel=0;
	m_SR2->channels.chanGain[0].gainOrRange = Gain2Code(0,AI,-1);
	m_SR2->status.typeStatus=IOVALUE;
	if (DriverLINX(m_SR2) == NoErr)
	{  // success
		float volts;
		int result;
		result = Code2Volts(0,AI,m_SR2->status.u.ioValue,&volts);
		m_aivalue.Format("%8.3f",volts);
		UpdateData(FALSE); // update the Dialog
	}
    else  // problem has occured
	{       showMessage(m_SR2);}  // display the error message box

}

void CMultsrDlg::OnInit() 
{

	// need to bring in the Device Number from the entry box on the dialog
	UpdateData(TRUE);  // updates our variables such as m_deviceNum;

		// pass in driver name to avoid the OpenDriverLINX Dialog
	m_driverInstance1=OpenDriverLINX(m_hWnd,"kpci3100");  // 
	m_driverInstance2=OpenDriverLINX(m_hWnd,"kpci3100");
	// kpci3100 driver name good for KPCI-3101 - KPCI-3104, KPCI-3110 and KPCI-3116
	//use kpci3108 for KPCI-3108 or KPCI-3107
	// kpci1800 for KPCI-180xHC boards
	// use kmb1800 for DAS-1800 Series boards
	// use kmb1700 for DAS-1700 Series boards

	m_SR1=(DL_ServiceRequest*) new DL_ServiceRequest;  // allocate the SR for each
	m_SR2=(DL_ServiceRequest*) new DL_ServiceRequest;
	memset(m_SR1,0,sizeof(DL_ServiceRequest));  // init the members
	memset(m_SR2,0,sizeof(DL_ServiceRequest));
	DL_SetServiceRequestSize(*m_SR1);
	m_SR1->operation=INITIALIZE;
	m_SR1->device=m_deviceNum;   // should correspond to the DriverLINX Config Panel
	m_SR1->mode=OTHER;
	m_SR1->subsystem=DEVICE;
	m_SR1->hWnd=m_hWnd;
	SelectDriverLINX(m_driverInstance1);
	if (DriverLINX(m_SR1) == NoErr)
	{ m_aiButton.EnableWindow(TRUE); }
	else
	{ showMessage(m_SR1);}
// initialize the second SR and board

	DL_SetServiceRequestSize(*m_SR2);
	m_SR2->operation=INITIALIZE;
	m_SR2->device=m_deviceNum;   // should correspond to the DriverLINX Config Panel
	m_SR2->mode=OTHER;
	m_SR2->subsystem=DEVICE;
	m_SR2->hWnd=m_hWnd;
	SelectDriverLINX(m_driverInstance2);
	if (DriverLINX(m_SR2) == NoErr)
	{ m_diButton.EnableWindow(TRUE); }
	else
	{ showMessage(m_SR2);}

	CWnd::SetActiveWindow();
}
